#include "stdafx.h"
#include "DffExp.h"
#include "common.h" //author name, etc.
#include "version.h"

extern HWND     hGMaxHWnd;

Class_ID
DFFClassDesc::ClassID()
{
    return Class_ID(0x26ca511f, 0x62650b34);
}

const TCHAR *
DFFExport::Ext(int n)
{
    const TCHAR *result = _T("");
    switch (n)
    {
        case 0:
        {
            result = _T("DFF");
            break;
        }
    }
    
    return result;
}

const TCHAR *
DFFExport::LongDesc(void)
{
    return _T(DFFLongDescription);
}

const TCHAR *
DFFExport::ShortDesc(void)
{
    return _T(DFFShortDescription);
}

const TCHAR *
DFFExport::AuthorName(void)
{            
    return _T(AUTHORNAME);
}

const TCHAR *
DFFExport::CopyrightMessage(void)
{    
    return _T(COPYRIGHT);
}

const TCHAR *
DFFExport::OtherMessage1(void) 
{        
    return _T("");
}

const TCHAR *
DFFExport::OtherMessage2(void)
{        
    return _T("");
}

unsigned int
DFFExport::Version(void)
{                
    return (VERSION);
}

void
DFFExport::ShowAbout(HWND hWnd)
{            
}

int
DFFExport::ExtCount(void)
{
    return (1);
}

RwExpError
DFFExport::ExportSelectFirstObjectNode(Interface *gi) 
//Search scene to find a selected node, beginning at scene root
//if the node isn't already directly beneath the root,
//find the node in the heirarchy it belongs to that is.
//On exit this function stuffs the data members:
//m_topOfSelectedHierarchy        -   highest node in heirarchy containing selected node
//m_selectedNodeInSelectedHierarchy        -   highest node in heirarchy containing selected node
//in the case that the user selects nodes in more than one heirarchy,
//we just return the first one we find and issue a warning dialog.
//If there was no node selected at all, we just return an error and a bunch of null pointers.
//(really this should not be a member function!)
{
    INode* rootNode = NULL;
    INode* selectedNode;
    INode* childNode;
    int nNumChildren, nChildNum;    
    BOOL multipleHierarchyMsgDisplayed = FALSE;
    BOOL result = FALSE;

    if(gi->GetSelNodeCount() == 0)  //get # selected nodes in the scene
    {
        return RwExpError("No Objects Selected");
    }
    
    //start at scene root
    rootNode = gi->GetRootNode();
    if(!rootNode)
    {
        return RwExpError("Root Node not found");
    }

    nNumChildren = rootNode->NumberOfChildren();
    m_topOfSelectedHierarchy = NULL;

    /* For every child of the root... */
    for (nChildNum = 0; nChildNum < nNumChildren; nChildNum++)
    {
        childNode = rootNode->GetChildNode(nChildNum);
        int nNumSelectedNodes = gi->GetSelNodeCount();
        int selectedNodeNum;

        /* For every selected node... */
        for (selectedNodeNum = 0; selectedNodeNum < nNumSelectedNodes; selectedNodeNum++)
        {
            selectedNode = gi->GetSelNode(selectedNodeNum);

            /* If the selected node isn't the child of the root... */
            while (!selectedNode->GetParentNode()->IsRootNode())
            {
                /* Get the node's parent. */
                selectedNode = selectedNode->GetParentNode();
            }
            
            /* If this is the child of the root node. */
            if (childNode == selectedNode)
            {
                if(!result)
                {
                    result = TRUE;
                    m_topOfSelectedHierarchy = selectedNode;
                    m_selectedNodeInSelectedHierarchy = gi->GetSelNode(selectedNodeNum);

                    /* Stop searching this node. */
                    break;
                }
                else
                {
                    if (!multipleHierarchyMsgDisplayed)
                    {
                        char temp[256];
                        sprintf(temp,"RenderWare %s Dff Exporter",VersionNumberText);
                        MessageBox(hGMaxHWnd, 
                           "Attempt to export multiple hierarchies, exporting first found", 
                           temp, MB_OK );
                        multipleHierarchyMsgDisplayed = TRUE;
                    }
                }
            }
        }
    }

    //okay
    return RwExpError("");
}

RwBool
DFFExport::ExportSelectNextObjectNode(Interface *gi) 
{
    m_topOfSelectedHierarchy = NULL;
    m_selectedNodeInSelectedHierarchy = NULL;

    return(FALSE);
}

RwBool
DFFExport::InitialiseCustomNodeData(INode *node)
{
    return(TRUE);
}

RwBool
DFFExport::SetCustomNodeData(INode *node)
{
    return(TRUE);
}

RwBool
DFFExport::InitialiseCustomFrameData(INode* node, RwFrame *fpFrame)
{
    return(TRUE);
}


RwBool
DFFExport::SetCustomFrameData(INode* node, RwFrame *fpFrame)
{
    return(TRUE);
}

RwBool
DFFExport::CustomiseFileName(TCHAR *filename)
{
    return(TRUE);
}

RwBool
DFFExport::ExportCustomData(char *filename, INode *node)
{
    return(TRUE);
}

RwBool
DFFExport::CustomIgnoreNodeAndChildren(INode *node)
{
    return(FALSE);
}

RwBool
DFFExport::ExportCustomNode(INode *node, Object *object, RwFrame *frame, RpClump *clump)
{
    /* don't want to customise node export */
    return (FALSE);
}